/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.file.CmdDataSelector;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDComboBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class PathSelectPanel
extends QDPanel
implements ItemListener,
ActionListener {
    private static final String PATH_KEY = "path_list";
    private FmtFileType m_type;
    private QDComboBox m_typeList;
    private QDComboBox m_pathList;
    private ItemListener m_pathListener;
    private QDButton m_changePathBtn;
    private InstrumentSource m_isrc;
    private boolean m_ignoreItemEvents = false;
    private boolean m_typeChangeAllowed = true;

    public PathSelectPanel(FmtFileType fmtFileType, InstrumentSource instrumentSource) {
        this.m_type = fmtFileType;
        if (this.m_type.getCmdType().length() == 0) {
            this.m_type = FmtFileType.FORMAT;
        }
        this.m_isrc = instrumentSource;
        this.initComponents();
        this.fillPathList();
        this.m_typeList.setSelectedItem((Object)this.m_type.fullName());
        this.m_typeList.addItemListener((ItemListener)this);
        this.m_pathList.addItemListener((ItemListener)this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_typeList) {
            if (itemEvent.getStateChange() == 1) {
                this.typeChanged();
            }
        } else if (itemEvent.getSource() == this.m_pathList && !this.m_ignoreItemEvents && this.m_pathListener != null) {
            this.m_pathListener.itemStateChanged(itemEvent);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_pathList = new QDComboBox();
        this.m_pathList.setEditable(false);
        this.m_pathList.setToolTipText("Select the current path setting for the selected type");
        this.m_changePathBtn = new QDButton("Edit Path");
        this.m_changePathBtn.useSmallFont(true);
        this.m_changePathBtn.setToolTipText("Enter a new path");
        this.m_changePathBtn.setActionCommand("edit");
        this.m_changePathBtn.addActionListener((ActionListener)this);
        this.m_typeList = new QDComboBox();
        this.m_typeList.setEditable(false);
        this.m_typeList.setToolTipText("Select a path type (Format = FMTP, Source Menu = DIRP)");
        for (FmtFileType fmtFileType : FmtFileType.values()) {
            String string = fmtFileType.getCmdType();
            if (string.length() <= 0) continue;
            this.m_typeList.addItem((Object)fmtFileType.fullName());
        }
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        QDLabel qDLabel = new QDLabel("Type: ");
        this.add((Component)qDLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_typeList, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        qDLabel = new QDLabel("  Path: ");
        this.add((Component)qDLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.m_pathList, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.m_changePathBtn, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("edit")) {
            this.editPath();
        }
    }

    private void fillPathList() {
        String[] stringArray;
        this.m_ignoreItemEvents = true;
        this.m_pathList.removeAllItems();
        Preferences preferences = Preferences.userNodeForPackage(CmdDataSelector.class);
        for (String string : stringArray = preferences.get(this.m_type.getCmdType() + PATH_KEY, "").split("\t")) {
            if ((string = string.trim()).length() <= 0) continue;
            this.addPath(string);
        }
        this.m_ignoreItemEvents = false;
    }

    private void typeChanged() {
        String string = (String)this.m_typeList.getSelectedItem();
        if (string == null) {
            return;
        }
        for (FmtFileType fmtFileType : FmtFileType.values()) {
            if (!fmtFileType.fullName().equals(string)) continue;
            this.m_type = fmtFileType;
            break;
        }
        this.fillPathList();
        try {
            this.readPath();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.pathSelected();
    }

    public String getFullFileName(String string) {
        String string2 = string.replace('\\', '/');
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            String string3 = this.getSelectedPath();
            if (string3 == null) {
                return string2;
            }
            if (string3.indexOf(59) >= 0) {
                return string2;
            }
            return string3 + "/" + string2;
        }
        return string2;
    }

    public String getPath() {
        String string = this.getSelectedPath();
        if (string == null) {
            return null;
        }
        string = string.replace(";", " ");
        return string;
    }

    public FmtFileType getType() {
        return this.m_type;
    }

    public void enableTypeSelection(boolean bl) {
        this.m_typeChangeAllowed = bl;
        this.m_typeList.setEnabled(bl);
    }

    public String getSelectedPath() {
        return (String)this.m_pathList.getSelectedItem();
    }

    public void setEnabled(boolean bl) {
        this.m_pathList.setEnabled(bl);
        this.m_typeList.setEnabled(bl && this.m_typeChangeAllowed);
        this.m_changePathBtn.setEnabled(bl);
    }

    public void writePath() throws InstrumentException {
        String string = this.getPath();
        if (string == null) {
            return;
        }
        if (!this.m_isrc.isConnected()) {
            return;
        }
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        remoteInstrument.tryCommand(this.m_type.getCmdType() + "P " + string);
    }

    public boolean readPath() throws InstrumentException {
        if (!this.m_isrc.isConnected()) {
            this.setEnabled(false);
            return false;
        }
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        String string = remoteInstrument.tryQuery(this.m_type.getCmdType() + "P?");
        string = string.replace("\r\n", ";");
        this.addPath(string);
        return true;
    }

    public void setItemListener(ItemListener itemListener) {
        this.m_pathListener = itemListener;
    }

    public void addPath(String string) {
        this.m_ignoreItemEvents = true;
        this.addPathInternal(string);
        this.m_ignoreItemEvents = false;
    }

    private void addPathInternal(String string) {
        String string2;
        int n;
        int n2 = this.m_pathList.getItemCount();
        for (n = 0; n < n2; ++n) {
            string2 = (String)this.m_pathList.getItemAt(n);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.m_pathList.setSelectedIndex(n);
            return;
        }
        if (n2 > 10) {
            this.m_pathList.removeItemAt(0);
        }
        this.m_pathList.addItem((Object)string);
        this.m_pathList.setSelectedIndex(this.m_pathList.getItemCount() - 1);
        Preferences preferences = Preferences.userNodeForPackage(CmdDataSelector.class);
        n2 = this.m_pathList.getItemCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            string2 = (String)this.m_pathList.getItemAt(n);
            if (n > 0) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(string2);
        }
        preferences.put(this.m_type.getCmdType() + PATH_KEY, stringBuffer.toString());
    }

    private void pathSelected() {
        if (this.m_pathListener != null) {
            this.m_pathListener.itemStateChanged(new ItemEvent((ItemSelectable)this.m_pathList, 1, null, 1));
        }
    }

    private void editPath() {
        String string = this.getSelectedPath();
        Object object = JOptionPane.showInputDialog((Component)((Object)this), this.m_type.getCmdType() + " Path:", "Change Path?", 3, null, null, string);
        if (object == null || !(object instanceof String)) {
            return;
        }
        String string2 = (String)object;
        if (string2.equalsIgnoreCase(string)) {
            return;
        }
        this.addPath(string2);
        this.pathSelected();
    }
}

